﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EntityCommands;
using Mdws2ORM;
using Mdws2ORM.Core;
using Mdws2ORM.Maps;

namespace BMS.VistaIntegration.Via.Commands.EIS
{
    public class ListHospitalLocationCommand : BaseListCommand<HospitalLocation>
    {
        public const string Target = "LISTHOSPITALLOCATIONS";
        public const int ArgumentsCount = 3;

        public ListHospitalLocationCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        protected override string GetTarget()
        {
            return Target;
        }

        protected override IEnumerable<object> GetCriteria()
        {
            return new object[] { string.Empty }.Concat(base.GetCriteria());
        }

        protected override IDependencySource GetDependencySource()
        {
            return HospitalLocationDependencySource.Instance;
        }
    }

    internal sealed class HospitalLocationDependencySource : IDependencySource
    {
        private static IDependencySource instance;

        private HospitalLocationDependencySource()
        {
        }

        public static IDependencySource Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new HospitalLocationDependencySource();
                }

                return instance;
            }
        }

        public IEnumerable<DependentEntityInfo> GetDependentTypes()
        {
            yield return new DependentEntityInfo<WardLocation>(ListWardLocationCommand.Target, ListWardLocationCommand.ArgumentsCount, "42");
        }
    }
}
